/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumextras.foundation.darkness;

import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;
import toni.sodiumextras.EmbyConfig;
import toni.sodiumextras.EmbyTools;

public class DarknessPlus {
    public static final double MIN = 0.03;
    public static boolean enabled = false;
    private static final float[][] LUMINANCE = new float[16][16];

    public static class_243 getDarkFogColor(class_243 vanilla, double factor) {
        if (factor == 1.0) {
            return vanilla;
        }
        return new class_243(Math.max(0.03, vanilla.field_1352 * factor), Math.max(0.03, vanilla.field_1351 * factor), Math.max(0.03, vanilla.field_1350 * factor));
    }

    private static boolean isDark(class_1937 world) {
        if (EmbyConfig.darknessMode.get() == EmbyConfig.DarknessMode.OFF) {
            return false;
        }
        class_5321 dimType = world.method_27983();
        if (dimType == class_1937.field_25179) {
            return EmbyConfig.darknessOnOverworldCache;
        }
        if (dimType == class_1937.field_25180) {
            return EmbyConfig.darknessOnNetherCache;
        }
        if (dimType == class_1937.field_25181) {
            return EmbyConfig.darknessOnEndCache;
        }
        if (EmbyTools.isWhitelisted(dimType.method_29177(), EmbyConfig.darknessDimensionWhiteList)) {
            return true;
        }
        if (world.method_8597().comp_642()) {
            return EmbyConfig.darknessByDefaultCache;
        }
        return EmbyConfig.darknessOnNoSkyLightCache;
    }

    private static float skyFactor(class_1937 world) {
        if (EmbyConfig.darknessBlockLightOnlyCache || !DarknessPlus.isDark(world)) {
            return 1.0f;
        }
        if (!world.method_8597().comp_642()) {
            return 0.0f;
        }
        float angle = world.method_30274(0.0f);
        if (!(angle > 0.25f) || !(angle < 0.75f)) {
            return 1.0f;
        }
        float oldWeight = Math.max(0.0f, Math.abs(angle - 0.5f) - 0.2f) * 20.0f;
        float moon = EmbyConfig.darknessAffectedByMoonPhaseCache ? world.method_30272() : 0.0f;
        float moonInterpolated = (float)class_3532.method_16436((double)moon, (double)EmbyConfig.darknessNewMoonBrightCache, (double)EmbyConfig.darknessFullMoonBrightCache);
        return class_3532.method_16439((float)(oldWeight * oldWeight * oldWeight), (float)moonInterpolated, (float)1.0f);
    }

    public static int darken(int c, int blockIndex, int skyIndex) {
        float lTarget = LUMINANCE[blockIndex][skyIndex];
        float r = (float)(c & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c >> 16 & 0xFF) / 255.0f;
        float l = DarknessPlus.luminance(r, g, b);
        float f = l > 0.0f ? Math.min(1.0f, lTarget / l) : 0.0f;
        return f == 1.0f ? c : 0xFF000000 | Math.round(f * r * 255.0f) | Math.round(f * g * 255.0f) << 8 | Math.round(f * b * 255.0f) << 16;
    }

    public static float luminance(float r, float g, float b) {
        return r * 0.2126f + g * 0.7152f + b * 0.0722f;
    }

    public static void updateLuminance(float tickDelta, class_310 client, class_757 gameRenderer, float prevFlicker) {
        class_638 level = client.field_1687;
        if (level == null) {
            return;
        }
        boolean isDarkOnLevel = DarknessPlus.isDark((class_1937)level);
        boolean bl = enabled = !(!isDarkOnLevel || client.field_1724.method_6059(class_1294.field_5925) || client.field_1724.method_6059(class_1294.field_5927) && client.field_1724.method_3140() > 0.0f || level.method_23789() > 0);
        if (!enabled) {
            return;
        }
        float dimSkyFactor = DarknessPlus.skyFactor((class_1937)level);
        float ambient = level.method_23783(1.0f);
        class_2874 dim = level.method_8597();
        for (int skyIndex = 0; skyIndex < 16; ++skyIndex) {
            float v;
            float skyFactor = 1.0f - (float)skyIndex / 15.0f;
            skyFactor = 1.0f - skyFactor * skyFactor * skyFactor * skyFactor;
            skyFactor *= dimSkyFactor;
            float value = ((EmbyConfig.DarknessMode)((Object)EmbyConfig.darknessMode.get())).value;
            if (value == -1.0f) {
                throw new IllegalStateException("Darkness value can't be negative");
            }
            float min = Math.max(skyFactor * 0.05f, value);
            float rawAmbient = ambient * skyFactor;
            float minAmbient = rawAmbient * (1.0f - min) + min;
            float skyBase = class_765.method_23284((class_2874)dim, (int)skyIndex) * minAmbient;
            min = Math.max(0.35f * skyFactor, value);
            float skyRed = v = skyBase * (rawAmbient * (1.0f - min) + min);
            float skyGreen = v;
            float skyBlue = skyBase;
            if (gameRenderer.method_3195(tickDelta) > 0.0f) {
                float skyDarkness = gameRenderer.method_3195(tickDelta);
                skyRed = skyRed * (1.0f - skyDarkness) + skyRed * 0.7f * skyDarkness;
                skyGreen = skyGreen * (1.0f - skyDarkness) + skyGreen * 0.6f * skyDarkness;
                skyBlue = skyBlue * (1.0f - skyDarkness) + skyBlue * 0.6f * skyDarkness;
            }
            for (int blockIndex = 0; blockIndex < 16; ++blockIndex) {
                float blockFactor = 1.0f - (float)blockIndex / 15.0f;
                blockFactor = 1.0f - blockFactor * blockFactor * blockFactor * blockFactor;
                float blockBase = blockFactor * class_765.method_23284((class_2874)dim, (int)blockIndex) * (prevFlicker * 0.1f + 1.5f);
                min = 0.4f * blockFactor;
                float blockGreen = blockBase * ((blockBase * (1.0f - min) + min) * (1.0f - min) + min);
                float blockBlue = blockBase * (blockBase * blockBase * (1.0f - min) + min);
                float red = skyRed + blockBase;
                float green = skyGreen + blockGreen;
                float blue = skyBlue + blockBlue;
                float f = Math.max(skyFactor, blockFactor);
                min = 0.03f * f;
                red = red * (0.99f - min) + min;
                green = green * (0.99f - min) + min;
                blue = blue * (0.99f - min) + min;
                if (level.method_27983() == class_1937.field_25181) {
                    red = skyFactor * 0.22f + blockBase * 0.75f;
                    green = skyFactor * 0.28f + blockGreen * 0.75f;
                    blue = skyFactor * 0.25f + blockBlue * 0.75f;
                }
                if (red > 1.0f) {
                    red = 1.0f;
                }
                if (green > 1.0f) {
                    green = 1.0f;
                }
                if (blue > 1.0f) {
                    blue = 1.0f;
                }
                float gamma = ((Double)client.field_1690.method_42473().method_41753()).floatValue() * f;
                float invRed = 1.0f - red;
                float invGreen = 1.0f - green;
                float invBlue = 1.0f - blue;
                invRed = 1.0f - invRed * invRed * invRed * invRed;
                invGreen = 1.0f - invGreen * invGreen * invGreen * invGreen;
                invBlue = 1.0f - invBlue * invBlue * invBlue * invBlue;
                red = red * (1.0f - gamma) + invRed * gamma;
                green = green * (1.0f - gamma) + invGreen * gamma;
                blue = blue * (1.0f - gamma) + invBlue * gamma;
                min = Math.max(0.03f * f, ((EmbyConfig.DarknessMode)((Object)EmbyConfig.darknessMode.get())).value);
                red = red * (0.99f - min) + min;
                green = green * (0.99f - min) + min;
                blue = blue * (0.99f - min) + min;
                if (red > 1.0f) {
                    red = 1.0f;
                }
                if (green > 1.0f) {
                    green = 1.0f;
                }
                if (blue > 1.0f) {
                    blue = 1.0f;
                }
                if (red < 0.0f) {
                    red = 0.0f;
                }
                if (green < 0.0f) {
                    green = 0.0f;
                }
                if (blue < 0.0f) {
                    blue = 0.0f;
                }
                DarknessPlus.LUMINANCE[blockIndex][skyIndex] = DarknessPlus.luminance(red, green, blue);
            }
        }
    }
}

